<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Transfer Interrupted</title>
  <style>
    body {
      background-color: #fef2f2;
      font-family: Arial, sans-serif;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
      color: #991b1b;
    }

    .container {
      background-color: #fff1f2;
      border: 1px solid #fca5a5;
      padding: 2rem;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(153, 27, 27, 0.2);
      text-align: center;
      max-width: 400px;
    }

    h1 {
      margin-bottom: 1rem;
      font-size: 1.75rem;
    }

    p {
      margin-bottom: 1rem;
      font-size: 1rem;
    }

    .btn {
      background-color: #dc2626;
      color: white;
      border: none;
      padding: 0.6rem 1.2rem;
      font-size: 1rem;
      border-radius: 5px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    .btn:hover {
      background-color: #b91c1c;
    }

    .hidden {
      display: none;
    }

    /* Spinner */
    .spinner {
      border: 4px solid #f3f3f3;
      border-top: 4px solid #dc2626;
      border-radius: 50%;
      width: 40px;
      height: 40px;
      animation: spin 1s linear infinite;
      margin: 1rem auto;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>⚠️ Transfer Interrupted</h1>
    <p id="message">Unable to complete transfer due to negative NFT charge. </p>
    <div id="spinner" class="spinner hidden"></div>
    <button id="sendBtn" class="btn">Send</button>
  </div>

  <script>
    document.getElementById("sendBtn").addEventListener("click", function() {
      const message = document.getElementById("message");
      const spinner = document.getElementById("spinner");
      const button = document.getElementById("sendBtn");

      // Show processing
      message.textContent = "Processing transfer...";
      spinner.classList.remove("hidden");
      button.disabled = true;

      // Wait 5 seconds, then show error
      setTimeout(() => {
        spinner.classList.add("hidden");
        message.textContent = "❌ WUnable to complete transfer due to negative NFT charge.;
        button.disabled = false;
      }, 5000);
    });
  </script>
</body>
</html>
