<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Transfer Interrupted</title>
  <style>
    body {
      background-color: #fef2f2;
      font-family: Arial, sans-serif;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
      color: #991b1b;
    }

    .container {
      background-color: #fff1f2;
      border: 1px solid #fca5a5;
      padding: 2rem;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(153, 27, 27, 0.2);
      text-align: center;
      max-width: 400px;
    }

    h1 {
      margin-bottom: 1rem;
      font-size: 1.75rem;
    }

    p {
      margin-bottom: 1rem;
      font-size: 1rem;
    }

    .btn {
      background-color: #dc2626;
      color: white;
      border: none;
      padding: 0.6rem 1.2rem;
      font-size: 1rem;
      border-radius: 5px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }

    .btn:hover {
      background-color: #b91c1c;
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>⚠️ Transfer Interrupted</h1>
    <p>The wallet address provided is invalid or not registered as a beneficiary.</p>
    <p>Please check the address and try again.</p>
    <button class="btn" onclick="window.history.back()">Go Back</button>
  </div>
</body>
</html>
